// XISLCallDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "ib.h"
#include "XISLCallDlg.h"
#include "IBFlowView.h"
#include "XISLDoc.h"
#include "XISLCallTag.h"
#include "XISLVarDlg.h"
#include "XISLChangeVarDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CXISLRootTag *g_pAppRootTag;
/////////////////////////////////////////////////////////////////////////////
// CXISLCallDlg _CAO


CXISLCallDlg::CXISLCallDlg(CXISLCallTag *pCallTag,CXISLTag *pCurrentTag,CWnd* pParent /*=NULL*/)
	: CDialog(CXISLCallDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CXISLCallDlg)
	m_strDiaNameList = _T("");
	m_strNameList = _T("");
	m_strReturnList = _T("");
	m_strString = _T("");
	m_nValue = 0;
	m_nVarNum = 0;
	//}}AFX_DATA_INIT
	m_pParentView = NULL;
	m_bOKFlag = FALSE;
	m_bNameList = FALSE;
	m_bReturnList = FALSE;
	m_pNextDialogTag = NULL;
	m_pReturnList = NULL;

	m_pCurrentTag = pCurrentTag;
	m_nType = pCallTag->m_nTagType;
	if(m_nType == ID_TAG_CALL)
		m_pReturnList = new CPtrList;
	m_pCallTag = pCallTag;
}

void CXISLCallDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CXISLCallDlg)
	DDX_Control(pDX, IDC_NOASSIGN_DIALOG, m_naDialog);
	DDX_Control(pDX, IDC_EDIT_RETLIST, m_editRetList);
	DDX_Control(pDX, IDC_EDIT_NAMELIST, m_editNameList);
	DDX_Control(pDX, IDC_LIST_VAR, m_lbVar);
	DDX_Control(pDX, IDC_COMBO_DOCUMENT, m_cmbDocument);
	DDX_Control(pDX, IDC_COMBO_DIALOG, m_cmbDialog);
	DDX_Text(pDX, IDC_EDIT_DIALOG_NL, m_strDiaNameList);
	DDX_Text(pDX, IDC_EDIT_NAMELIST, m_strNameList);
	DDX_Text(pDX, IDC_EDIT_RETLIST, m_strReturnList);
	DDX_Text(pDX, IDC_EDIT_STRING, m_strString);
	DDX_Text(pDX, IDC_EDIT_VALUE, m_nValue);
	DDV_MinMaxInt(pDX, m_nValue, -9999999, 9999999);
	DDX_Text(pDX, IDC_EDIT_VARNUM, m_nVarNum);
	DDV_MinMaxInt(pDX, m_nVarNum, 0, 9999);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CXISLCallDlg, CDialog)
	//{{AFX_MSG_MAP(CXISLCallDlg)
	ON_CBN_SELCHANGE(IDC_COMBO_DIALOG, OnSelchangeComboDialog)
	ON_CBN_SELCHANGE(IDC_COMBO_DOCUMENT, OnSelchangeComboDocument)
	ON_EN_SETFOCUS(IDC_EDIT_NAMELIST, OnSetfocusEditNamelist)
	ON_EN_SETFOCUS(IDC_EDIT_RETLIST, OnSetfocusEditRetlist)
	ON_CBN_SETFOCUS(IDC_COMBO_DIALOG, OnSetfocusComboDialog)
	ON_CBN_SETFOCUS(IDC_COMBO_DOCUMENT, OnSetfocusComboDocument)
	ON_EN_SETFOCUS(IDC_EDIT_DIALOG_NL, OnSetfocusEditDialogNl)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_VAR, OnDblclkListVar)
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_BUTTON_NEWVAR, OnButtonNewvar)
	ON_BN_CLICKED(IDC_BUTTON_CHANGE, OnButtonChange)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_NOASSIGN_DIALOG, OnNoassignDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CXISLCallDlg bZ[W nh

BOOL CXISLCallDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	ASSERT(m_pParentView);

	CString strTemp;
	CXISLDoc *pDoc = (CXISLDoc*)m_pParentView->GetDocument();
	strTemp = pDoc->GetTitle();
	m_s2omapDocument.SetAt(strTemp,pDoc);
	m_cmbDocument.AddString(strTemp);
	CDocTemplate* pTemplate = pDoc->GetDocTemplate();
	POSITION pos = pTemplate->GetFirstDocPosition();
	while(pos)
	{
		CXISLDoc *pTempDoc = (CXISLDoc*)pTemplate->GetNextDoc(pos);
		if(pTempDoc == pDoc)
			continue;
		strTemp = pTempDoc->GetTitle();
		m_cmbDocument.AddString(strTemp);
		m_s2omapDocument.SetAt(strTemp,pTempDoc);
	}

	if(m_pCallTag->m_pNextDialog)
	{
		m_pNextDialogTag = m_pCallTag->m_pNextDialog;
		//ϐ̎QƉ񐔂炵Ă
		//OK or CANCEL̂Ƃɂ܂ǉ
		POSITION pos = m_pCallTag->m_NameList.GetHeadPosition();
		while(pos)
		{
			CXISLVar *pVar = (CXISLVar*)m_pCallTag->m_NameList.GetNext(pos);
			if(!pVar->IsDummy())
			{
				pVar->m_pParent->ReferVar(pVar->GetVarName(),FALSE);
				m_NameList.AddTail(pVar);
			}
			else
			{
				//ϐł͂Ȃlł
				CXISLVar *pValue = new CXISLVar;
				pValue->SetAttribute(pVar->GetVarName(),"",FALSE,TRUE);
				m_NameList.AddTail(pValue);
			}
		}
		if(m_nType == ID_TAG_CALL && m_pCallTag->m_pReturnList)
		{
			pos = m_pCallTag->m_pReturnList->GetHeadPosition();
			while(pos)
			{
				CXISLVar *pVar = (CXISLVar*)m_pCallTag->m_pReturnList->GetNext(pos);
				m_pReturnList->AddTail(pVar);
				if(!pVar->IsDummy())
					pVar->m_pParent->ReferVar(pVar->GetVarName(),FALSE);
			}
		}

		if(m_pCallTag->m_pNextDialog->IsDummy())
		{
			CString strDcoName = m_pCallTag->m_pNextDialog->GetDocName();
			CString strMsg;
			strMsg.Format("Jڐł%s̓[hĂ܂\r\n[h܂H",
				strDcoName);

			if(AfxMessageBox(strMsg,MB_OKCANCEL|MB_APPLMODAL|MB_ICONINFORMATION,0) != IDOK)
			{
				OnCancel();
				return TRUE;
			}

			CXISLDoc *pNewDoc = ((CIBApp*)AfxGetApp())->OpenXISLFrm(strDcoName);
			if(pNewDoc == NULL)
			{
				OnCancel();
				return TRUE;
			}
			strDcoName = pNewDoc->GetTitle();
			m_cmbDocument.AddString(strDcoName);
			m_s2omapDocument.SetAt(strDcoName,pNewDoc);
		}

		m_pNextDialogTag = m_pCallTag->m_pNextDialog;
		m_pNextDialogTag->RemoveReCallTag(m_pCallTag);
		CString strDoc = m_pNextDialogTag->GetDocName();
		//XISLt@C.xisl폜@2003/5/21@ǉ
		CString strDocNameNoXisl = strDoc.SpanExcluding(".xisl");
		int nIndex = m_cmbDocument.FindString(-1,strDocNameNoXisl);
		if(nIndex == -1)
			return FALSE;
		m_cmbDocument.SetCurSel(nIndex);
		OnSelchangeComboDocument();
		CString strDialogID = m_pNextDialogTag->GetDialogID();
		m_cmbDialog.SetCurSel(m_cmbDialog.FindString(-1,strDialogID));
		OnSelchangeComboDialog();
		GetNameList(m_strNameList);
		if(m_pCallTag->m_nTagType == ID_TAG_CALL)
			GetReturnList(m_strReturnList);
		GetDlgItem(IDCANCEL)->EnableWindow(FALSE);
	}
	else
	{
		m_pCallTag->InitPtrList();
		m_cmbDocument.SetCurSel(0);
		OnSelchangeComboDocument();
		GetDlgItem(IDOK)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_NAMELIST)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_RETLIST)->EnableWindow(FALSE);
	}

	if(m_nType == ID_TAG_GOTO)
	{
		SetWindowText("goto̕ҏW");
		GetDlgItem(IDC_EDIT_RETLIST)->EnableWindow(FALSE);
	}

	m_lbVar.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);
	LVCOLUMNA column;
	column.mask = LVCF_TEXT|LVCF_WIDTH;

	RECT rect;
	m_lbVar.GetClientRect(&rect);
	column.cx = 50;
	column.pszText = "Scope";
	m_lbVar.InsertColumn(0,&column);

	column.cx = (rect.right-rect.left)-50;
	column.pszText = "ϐ";
	m_lbVar.InsertColumn(1,&column);

	int nType = m_pCurrentTag->m_nTagType;
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pCurrentTag->GetParentExcTag();
	int nCount = pExcItem->m_pLocalVar->SetVar2ListBox(m_lbVar);
		
	CXISLDialogTag *pDTag = (CXISLDialogTag*)m_pCurrentTag->GetParentDialogTag();
	nCount = pDTag->m_pDialogVar->SetVar2ListBox(m_lbVar,nCount);
		
	CXISLRootTag *pRTag = (CXISLRootTag*)pDTag->GetRootTag();
	nCount = pRTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
		
	if(!pRTag->IsAppRoot() && g_pAppRootTag)
		g_pAppRootTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);

	m_brEdit.CreateSolidBrush(RGB(255,255,255));

	UpdateData(FALSE);
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CXISLCallDlg::OnSelchangeComboDocument() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	m_bOKFlag = FALSE;
	m_s2pmapDialog.RemoveAll();
	m_cmbDialog.ResetContent();

	CString strDoc;
	m_cmbDocument.GetWindowText(strDoc);

	CXISLDoc *pDoc;
	m_s2omapDocument.Lookup(strDoc,((CObject*&)pDoc));

	CString strKey;
	CXISLDialogTag *pTag;
	pDoc->GetDialogMap(m_s2pmapDialog);
	POSITION pos = m_s2pmapDialog.GetStartPosition();
	while(pos)
	{
		m_s2pmapDialog.GetNextAssoc(pos,strKey,(void*&)pTag);
		m_cmbDialog.AddString(strKey);
	}
}

void CXISLCallDlg::OnSelchangeComboDialog() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	if(!m_bOKFlag)
	{
		GetDlgItem(IDOK)->EnableWindow();
		GetDlgItem(IDC_EDIT_NAMELIST)->EnableWindow();
		if(m_nType == ID_TAG_CALL)
			GetDlgItem(IDC_EDIT_RETLIST)->EnableWindow();
		m_bOKFlag = TRUE;
	}

	CString strDialog;
	m_cmbDialog.GetWindowText(strDialog);

	CXISLDialogTag *pDialogTag;
	m_s2pmapDialog.Lookup(strDialog,(void*&)pDialogTag);

	m_bNameList = TRUE;
	m_nNameListNum = pDialogTag->GetDialogArgCount();
	m_nVarNum = m_nNameListNum;

	if(m_nNameListNum != m_NameList.GetCount())
	{
		InitNameList();
		for(int i=0; i<m_nNameListNum; i++)
		{
			CXISLVar *pVar = new CXISLVar;
			pVar->SetAttribute("*","",FALSE,TRUE);
			m_NameList.AddTail(pVar);
		}
	}
	m_strNameList.Empty();
	GetNameList(m_strNameList);
	m_strDiaNameList = pDialogTag->GetXISLString();
	UpdateData(FALSE);
}

void CXISLCallDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	UpdateData();

	CString strKey;
	//Jڐ悪w肵Ă@2003/5/21@ǉ
	if(m_naDialog.GetCheck()==0){
		m_cmbDialog.GetWindowText(strKey);
		if(strKey.IsEmpty())
		{
			AfxMessageBox("Jڐ̃_CAOw肵Ă",
					MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
			return;
		}
		BOOL bRet = m_s2pmapDialog.Lookup(strKey,(void*&)m_pNextDialogTag);
		ASSERT(bRet);
	
		int nCount = m_pNextDialogTag->GetDialogArgCount();
		if( nCount != m_NameList.GetCount() )
		{
			AfxMessageBox("Jڐ̃_CAÖƍ܂",
					MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
			return;
		}
		POSITION pos = m_NameList.GetHeadPosition();
		while(pos)
		{
			CXISLVar *pVar = (CXISLVar*)m_NameList.GetNext(pos);
			if(pVar->IsDummy() && strcmp(pVar->GetVarName(),"*") == 0)
			{
				AfxMessageBox("w肵Ă",
					MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
				return;
			}
		}

		m_pCallTag->m_pNextDialog = m_pNextDialogTag;
		m_pNextDialogTag->AddReCallTag(m_pCallTag);


		m_pCallTag->InitPtrList();
		pos = m_NameList.GetHeadPosition();
		while(pos)
		{
			CXISLVar *pVar = (CXISLVar*)m_NameList.GetNext(pos);
			if(!pVar->IsDummy())
				pVar->m_pParent->ReferVar(pVar->GetVarName(),TRUE);
			m_pCallTag->m_NameList.AddTail(pVar);
		}
		if(m_nType == ID_TAG_CALL && m_pCallTag->m_pReturnList)
		{
			ASSERT(m_pReturnList);
			ASSERT(m_pCallTag->m_pReturnList);
			m_pCallTag->m_pReturnList->RemoveAll();
			pos = m_pReturnList->GetHeadPosition();
			while(pos)
			{
				CXISLVar *pVar = (CXISLVar*)m_pReturnList->GetNext(pos);
				if(!pVar->IsDummy())
					pVar->m_pParent->ReferVar(pVar->GetVarName(),TRUE);
				m_pCallTag->m_pReturnList->AddTail(pVar);
			}
		}
	}
	//Jڐw肵ĂȂꍇ && ReturnListݒ肵Ă@2003/5/21@ǉ
	else if(m_naDialog.GetCheck()==1 && (m_pCallTag->m_pReturnList || m_pCallTag->m_NameList.IsEmpty()==0)){
		ASSERT(m_pReturnList);
		ASSERT(m_pCallTag->m_pReturnList);
		m_pCallTag->m_NameList.RemoveAll();
		m_pCallTag->m_pReturnList->RemoveAll();
	}

	CDialog::OnOK();
}

void CXISLCallDlg::OnSetfocusEditNamelist() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	m_bNameList = TRUE;
	m_bReturnList = FALSE;
	if(m_nType == ID_TAG_CALL)
		m_editRetList.SetSel(0,0);
	GetDlgItem(IDC_EDIT_STRING)->EnableWindow(TRUE);
	GetDlgItem(IDC_EDIT_VALUE)->EnableWindow(TRUE);

}

void CXISLCallDlg::OnSetfocusEditRetlist() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	m_bNameList = FALSE;
	if(m_nType == ID_TAG_CALL)
		m_bReturnList = TRUE;
	m_editNameList.SetSel(0,0);
	GetDlgItem(IDC_EDIT_STRING)->EnableWindow(FALSE);
	GetDlgItem(IDC_EDIT_VALUE)->EnableWindow(FALSE);
}

void CXISLCallDlg::OnSetfocusComboDialog() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	m_bNameList = FALSE;
	m_bReturnList = FALSE;
}

void CXISLCallDlg::OnSetfocusComboDocument() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	m_bNameList = FALSE;
	m_bReturnList = FALSE;
}

void CXISLCallDlg::OnSetfocusEditDialogNl() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	m_bNameList = FALSE;
	m_bReturnList = FALSE;
}

void CXISLCallDlg::OnDblclkListVar(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	_TCHAR szBuff[MAX_PATH];
	LVITEMA item;
	item.mask = LVIF_TEXT|LVIF_PARAM|LVIF_STATE;
	item.iItem = pNMListView->iItem;
	item.iSubItem = 0;
	item.pszText = szBuff;
	item.cchTextMax = sizeof(szBuff);
	item.stateMask = 0xFFFF;
	m_lbVar.GetItem(&item);

	if(item.iItem != -1)
	{
		CXISLVar *pVar = (CXISLVar*)item.lParam;

		if(m_bNameList && m_nNameListNum != 0)
		{
			ReplaceNLVar(pVar);
			GetNameList(m_strNameList);
		}

		if(m_bReturnList)
		{
			ReplaceRLVar(pVar);
			GetReturnList(m_strReturnList);
		}
		UpdateData(FALSE);
	}
	*pResult = 0;
}


BOOL CXISLCallDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if( pMsg->message == WM_KEYDOWN )
	{
		CWnd *pWnd = GetFocus();
		CString strTemp;
		CXISLVar *pVar=NULL;
        switch( pMsg->wParam )
        {
        case VK_RETURN:   // Enter
			if(m_nNameListNum == 0)
				return TRUE;
			UpdateData();
			if(pWnd->GetDlgCtrlID() == IDC_EDIT_STRING)
			{
				strTemp = "'" + m_strString;
				strTemp += "'";
			}
			else if(pWnd->GetDlgCtrlID() == IDC_EDIT_VALUE)
			{
				strTemp.Format("%d",m_nValue);
			}
			pVar = new CXISLVar;
			pVar->SetAttribute(strTemp,"",FALSE,TRUE);
			ReplaceNLVar(pVar);
			GetNameList(m_strNameList);
			m_strString.Empty();
			m_nValue = 0;
			UpdateData(FALSE);
			return TRUE;
		case VK_DELETE:
			if(pWnd->GetDlgCtrlID() != IDC_EDIT_RETLIST)
				break;
			DeleteRetVar();
			GetReturnList(m_strReturnList);
			UpdateData(FALSE);
			break;
        default:
			break;
        }
	}
	else if(pMsg->message == WM_LBUTTONDOWN)
	{
		CDialog::PreTranslateMessage(pMsg);
		int nStart,nEnd;
		CWnd *pWnd = GetFocus();
		UpdateData();
		if(pWnd->GetDlgCtrlID() == IDC_EDIT_NAMELIST)
		{
			m_editNameList.GetSel(nStart,nEnd);
			nEnd = m_strNameList.Find(",",nStart);
			if(nEnd == -1)
				nEnd = m_strNameList.GetLength();
			if(nStart != 0)
			{
				nStart--;
				while(m_strNameList[nStart] != ',')
				{
					nStart--;
					if(nStart == -1)
						break;
				}
				nStart++;
			}
			m_editNameList.SetSel(nStart,nEnd);
		}
		else if(pWnd->GetDlgCtrlID() == IDC_EDIT_RETLIST)
		{
			m_editRetList.GetSel(nStart,nEnd);
			if(nStart != m_strReturnList.GetLength() && nEnd != 0)
			{
				nEnd = m_strReturnList.Find(",",nStart);
				if(nEnd == -1)
					nEnd = m_strReturnList.GetLength();
				if(nStart != 0)
				{
					nStart--;
					while(m_strReturnList[nStart] != ',')
					{
						nStart--;
						if(nStart == -1)
							break;
					}
					nStart++;
				}
			}
			m_editRetList.SetSel(nStart,nEnd);
		}
		return TRUE;
	}

	return CDialog::PreTranslateMessage(pMsg);
}

HBRUSH CXISLCallDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	
	// TODO: ̈ʒu DC ̃Agr[gύXĂ
	switch(nCtlColor)
	{
	case CTLCOLOR_STATIC:
		if(pWnd->GetDlgCtrlID() == IDC_EDIT_NAMELIST)
		{
			pDC->SetBkMode(TRANSPARENT);	// wi
			pDC->SetTextColor(RGB(0,0,0));	// eLXgFݒ
			return (HBRUSH) m_brEdit;		// _~[uV
		}
		else if(pWnd->GetDlgCtrlID() == IDC_EDIT_RETLIST)
		{
			pDC->SetBkMode(TRANSPARENT);	// wi
			pDC->SetTextColor(RGB(0,0,0));	// eLXgFݒ
			if(m_nType == ID_TAG_GOTO)
				return hbr;
			else
				return (HBRUSH) m_brEdit;
		}
			break;
//	case CTLCOLOR_DLG:
//		return hbr;		//@wiFuV
	default:
		break;
	}

	// TODO: ftHg̃uV]݂̂̂łȂꍇɂ́AႤuVԂĂ
	return hbr;
}


void CXISLCallDlg::OnButtonNewvar() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CXISLVarDlg VarDlg(m_pCurrentTag);
	if(VarDlg.DoModal() != IDOK)
		return;

	m_lbVar.DeleteAllItems();
	int nType = m_pCurrentTag->m_nTagType;
	if(nType == ID_TAG_EXCHANGE || nType == ID_TAG_BEGIN || nType == ID_TAG_END)
	{
		int nCount = ((CXISLExcItem*)m_pCurrentTag)->m_pLocalVar->SetVar2ListBox(m_lbVar);
		
		CXISLDialogTag *pDTag = (CXISLDialogTag*)m_pCurrentTag->GetParentDialogTag();
		nCount = pDTag->m_pDialogVar->SetVar2ListBox(m_lbVar,nCount);
		
		CXISLRootTag *pRTag = (CXISLRootTag*)pDTag->GetRootTag();
		nCount = pRTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
		
		if(!pRTag->IsAppRoot() && g_pAppRootTag)
			g_pAppRootTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
	}
}

void CXISLCallDlg::OnButtonChange() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	int nIndex;
	POSITION pos = m_lbVar.GetFirstSelectedItemPosition();
	if(pos == NULL)
		return;
	nIndex = m_lbVar.GetNextSelectedItem(pos);
	
	_TCHAR szBuff[MAX_PATH];
	LVITEMA item;
	item.mask = LVIF_TEXT|LVIF_PARAM|LVIF_STATE;
	item.iItem = nIndex;
	item.iSubItem = 0;
    item.pszText = szBuff;
    item.cchTextMax = sizeof(szBuff);
	item.stateMask = 0xFFFF;
	m_lbVar.GetItem(&item);

	CXISLVar *pVar = (CXISLVar*)item.lParam;
	CXISLChangeVarDlg CVarDlg(pVar);
	if(CVarDlg.DoModal() != IDOK)
		return;
}

void CXISLCallDlg::GetNameList(CString &strName)
{
	POSITION pos = m_NameList.GetHeadPosition();
	CString strTemp;
	strName.Empty();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_NameList.GetNext(pos);
		pVar->GetVarNameEx(strTemp);
		strName += strTemp;
		strName += ",";
	}
	strName.Delete(strName.GetLength()-1);
}

void CXISLCallDlg::GetReturnList(CString &strReturn)
{
	POSITION pos = m_pReturnList->GetHeadPosition();
	CString strTemp;
	strReturn.Empty();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_pReturnList->GetNext(pos);
		pVar->GetVarNameEx(strTemp);
		strReturn += strTemp;
		strReturn += ",";
	}
	strReturn.Delete(strReturn.GetLength()-1);
}

int CXISLCallDlg::GetSelectedNLVar()
{
	UpdateData();
	int nStart,nEnd;
	int nCount = 0;
	if(m_bNameList)
	{
		m_editNameList.GetSel(nStart,nEnd);

		nEnd = 0;
		while(1)
		{
			nEnd = m_strNameList.Find(",",nEnd);
			if(nEnd == -1 || nEnd >= nStart)
				break;
			nCount++;
			nEnd++;
		}
		return nCount;
	}
	else
		return -1;
}

int CXISLCallDlg::GetSelectedRLVar()
{
	UpdateData();
	int nStart,nEnd;
	int nCount = 0;
	if(m_bReturnList)
	{
		m_editRetList.GetSel(nStart,nEnd);
		if(nStart == m_strReturnList.GetLength())
			return -2;

		if(nStart == 0 && nEnd == 0)
			return -3;

		nEnd = 0;
		while(1)
		{
			nEnd = m_strReturnList.Find(",",nEnd);
			if(nEnd == -1 || nEnd >= nStart)
				break;
			nCount++;
			nEnd++;
		}
		return nCount;
	}
	return -1;
}
void CXISLCallDlg::ReplaceNLVar(CXISLVar *pVar)
{
	//IĂ̂ڂ̂̂
	int nIndex = GetSelectedNLVar();
	if(nIndex == -1)
		return;
	else
	{
		POSITION pos = m_NameList.FindIndex(nIndex);
		if(pos == NULL)
			ASSERT(NULL);
		CXISLVar *pSelectVar = (CXISLVar*)m_NameList.GetAt(pos);
		m_NameList.RemoveAt(pos);
		//ϐł͂ȂlȂ
		if(pSelectVar->IsDummy())
		{
			delete pSelectVar;
			pSelectVar = NULL;
		}
		pos = m_NameList.FindIndex(nIndex);
		if(pos)
			m_NameList.InsertBefore(pos,pVar);
		else
			m_NameList.AddTail(pVar);
	}
}

void CXISLCallDlg::ReplaceRLVar(CXISLVar *pVar)
{
	//IĂ̂ڂ̂̂
	int nIndex = GetSelectedRLVar();
	if(nIndex == -2)
		m_pReturnList->AddTail(pVar);
	else if(nIndex == -3)
		m_pReturnList->AddHead(pVar);
	else if(nIndex == -1)
		return;
	else
	{
		POSITION pos = m_pReturnList->FindIndex(nIndex);
		if(pos == NULL)
			ASSERT(NULL);
		m_pReturnList->RemoveAt(pos);
		pos = m_pReturnList->FindIndex(nIndex);
		if(pos)
			m_pReturnList->InsertBefore(pos,pVar);
		else
			m_pReturnList->AddTail(pVar);
	}
}

void CXISLCallDlg::DeleteRetVar()
{
	if(m_pReturnList->IsEmpty())
		return;

	int nIndex = GetSelectedRLVar();
	if(nIndex == -2)
		m_pReturnList->RemoveTail();
	else if(nIndex == -3)
		m_pReturnList->RemoveHead();
	else if(nIndex == -1)
		return;
	else
	{
		POSITION pos = m_pReturnList->FindIndex(nIndex);
		if(pos == NULL)
			ASSERT(NULL);
		m_pReturnList->RemoveAt(pos);
	}
}

void CXISLCallDlg::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	m_pCallTag->m_pNextDialog = m_pNextDialogTag;
	if(m_pCallTag->m_pNextDialog)
	{
		int nCount = m_pCallTag->m_pNextDialog->GetDialogArgCount();
		if( nCount != m_pCallTag->m_NameList.GetCount() )
		{
			AfxMessageBox("Jڐ̃_CAÖƍ܂",
					MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
			return;
		}

		InitNameList();
		//ϐ̎QƉ񐔂𑝂₷
		POSITION pos = m_pCallTag->m_NameList.GetHeadPosition();
		while(pos)
		{
			CXISLVar *pVar = (CXISLVar*)m_pCallTag->m_NameList.GetNext(pos);
			if(!pVar->IsDummy())
				pVar->m_pParent->ReferVar(pVar->GetVarName(),TRUE);
		}
		if(m_nType == ID_TAG_CALL && m_pCallTag->m_pReturnList)
		{
			pos = m_pCallTag->m_pReturnList->GetHeadPosition();
			while(pos)
			{
				CXISLVar *pVar = (CXISLVar*)m_pCallTag->m_pReturnList->GetNext(pos);
				if(!pVar->IsDummy())
					pVar->m_pParent->ReferVar(pVar->GetVarName(),TRUE);
			}
		}
	}
	CDialog::OnCancel();
}


void CXISLCallDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	if(m_pReturnList)
		delete m_pReturnList;
}

void CXISLCallDlg::InitNameList()
{
	POSITION oldPos = NULL;
	POSITION pos = m_NameList.GetHeadPosition();
	while(pos)
	{
		oldPos = pos;
		CXISLVar *pVar = (CXISLVar*)m_NameList.GetNext(pos);
		m_NameList.RemoveAt(oldPos);
		if(pVar->IsDummy())
			delete pVar;
	}
}

//Jڐ̎w
//2003/5/21@ǉ
void CXISLCallDlg::OnNoassignDialog() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	int button = m_naDialog.GetCheck();
	//Jڐw肷
	if(button == 0){
		GetDlgItem(IDOK)->EnableWindow(FALSE);
		GetDlgItem(IDC_COMBO_DOCUMENT)->EnableWindow(TRUE);
		GetDlgItem(IDC_COMBO_DIALOG)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_STRING)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_VALUE)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_NEWVAR)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_CHANGE)->EnableWindow(TRUE);
		GetDlgItem(IDC_LIST_VAR)->EnableWindow(TRUE);

	}
	//Jڐw肵Ȃ
	else if(button == 1){
		GetDlgItem(IDOK)->EnableWindow(TRUE);
		GetDlgItem(IDC_COMBO_DOCUMENT)->EnableWindow(FALSE);
		GetDlgItem(IDC_COMBO_DIALOG)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_STRING)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_VALUE)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_NEWVAR)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_CHANGE)->EnableWindow(FALSE);
		GetDlgItem(IDC_LIST_VAR)->EnableWindow(FALSE);
	}
}
